@echo off

chdir /D %~dp0

set KEY_NAME="HKEY_LOCAL_MACHINE\SYSTEM\CONTROLSET001\CONTROL\NLS\LANGUAGE"
set VALUE_NAME=Installlanguage

for /F "tokens=3 delims= " %%G in (
  'REG QUERY %KEY_NAME% /v %VALUE_NAME%') do (
    set INSTALL_LANG=%%G
)

set PRODUCT=AquaSoft DiaShow Easy Beta
set PRODUCT_ID={83E86F2D-E07C-4964-AC71-F9366558A021}
set INSTALLER_PATH=%WINDIR%\Installer\%PRODUCT_ID%

reg Query "HKLM\Hardware\Description\System\CentralProcessor\0" | find /i "x86" > NUL && set OS=32BIT || set OS=64BIT

if %OS%==32BIT (
  set SOFTWARE_KEY=SOFTWARE 
) else (
  set SOFTWARE_KEY=SOFTWARE\Wow6432Node
)

set ID_CACHE=%SOFTWARE_KEY%\MimarSinan\InstallAware\Ident.Cache
set KEY_NAME="HKEY_LOCAL_MACHINE\%ID_CACHE%\%PRODUCT_ID%"
set VALUE_NAME=""

for /F "usebackq skip=2 tokens=1,2*" %%A in (
 `REG QUERY %KEY_NAME% /v %VALUE_NAME% 2^>nul`) do (
    set "ValueName=%%A"
    set "ValueType=%%B"
    set CACHE_PATH="%%C"
)

if defined CACHE_PATH (
  set CACHE_PATH=%CACHE_PATH:"=%
  echo CACHE_PATH = %CACHE_PATH%
  rd %CACHE_PATH% /s /q
  if not exist %CACHE_PATH%\nul regtool -d -r3 "%ID_CACHE%\%PRODUCT_ID%\"
)

if not defined CACHE_PATH (
  if [%INSTALL_LANG%] EQU [0407] (
    echo %KEY_NAME%\%VALUE_NAME% nicht gefunden.
  ) else (
    echo %KEY_NAME%\%VALUE_NAME% not found.
  )
)

rd %INSTALLER_PATH% /s /q

rem HKEY_CURRENT_USER
regtool -d -r2 "%SOFTWARE_KEY%\Microsoft\Windows\CurrentVersion\Uninstall\%PRODUCT%\"
regtool -d -r2 "%SOFTWARE_KEY%\Microsoft\Windows\CurrentVersion\Uninstall\%PRODUCT_ID%\"
regtool -d -r2 "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\%PRODUCT%\"
regtool -d -r2 "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\%PRODUCT_ID%\"

rem HKEY_LOCAL_MACHINE
regtool -d -r3 "%SOFTWARE_KEY%\Microsoft\Windows\CurrentVersion\App Management\ARPCache\%PRODUCT%\"
regtool -d -r3 "%SOFTWARE_KEY%\Microsoft\Windows\CurrentVersion\App Management\ARPCache\%PRODUCT_ID%\"
regtool -d -r3 "%SOFTWARE_KEY%\Microsoft\Windows\CurrentVersion\Installer\Folders\%INSTALLER_PATH%\"
regtool -d -r3 "%SOFTWARE_KEY%\Microsoft\Windows\CurrentVersion\Uninstall\%PRODUCT_ID%\"
regtool -d -r3 "%SOFTWARE_KEY%\Microsoft\Windows\CurrentVersion\Uninstall\%PRODUCT%\"
regtool -d -r3 "%SOFTWARE_KEY%\MimarSinan\InstallAware\Ident.Cache\%PRODUCT_ID%\"

IF %ERRORLEVEL% == 0 goto ende

echo.
echo.
echo.

if [%INSTALL_LANG%] EQU [0407] (
  echo Fehler, regtool.exe nicht gefunden. Bitte entpacken Sie das komplette ZIP-Archiv vor dem Ausfuehren der Datei.
) else (
  echo Error, regtool.exe not found. Please unzip the complete ZIP archive before executing the file.
)

echo.
echo.
echo.

pause

:ende